﻿using System;
using System.Configuration;
using System.IO;
using System.Reflection;
using ClientDemo.Demos;
using log4net;
using Spring.Context.Support;
using gov.va.med.vbecs.Common.DependencyInjection;
using gov.va.med.vbecs.Common.Log;
using LogManager = gov.va.med.vbecs.Common.Log.LogManager;

namespace ClientDemo
{
    class Program
    {
        private static ILogger _logger;

        #region Private

        static private void initialise_dependencies()
        {
            //Globally setup log output file name
            GlobalContext.Properties["LogName"] = Path.GetFileNameWithoutExtension(Assembly.GetEntryAssembly().Location);
            GlobalContext.Properties["LogNameDated"] = Path.GetFileNameWithoutExtension(Assembly.GetEntryAssembly().Location) + DateTime.Now.ToString("_MM-dd-yyyy");
            var log4NetFile = Path.Combine(Path.GetDirectoryName(typeof(Program).Assembly.Location) ?? ".", ConfigurationManager.AppSettings.Get("log4net.Config"));
            log4net.Config.XmlConfigurator.ConfigureAndWatch(new FileInfo(log4NetFile));

            //Two configuration files are necessary since object in first file should be created and ready for object in the second one.
            var common = @"file://" + Path.Combine(Path.GetDirectoryName(typeof(Program).Assembly.Location) ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFileCommon"));
            var spring = @"file://" + Path.Combine(Path.GetDirectoryName(typeof(Program).Assembly.Location) ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFile"));
            DiContext.AppContext = new XmlApplicationContext(new[] { common, spring });

            //Here is the once-per-class call to initialize the log object
            //We have to do it after Spring.NET objects initialization.
            _logger = LogManager.Instance().LoggerLocator.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);

        }

        #endregion

        static void Main()
        {
            initialise_dependencies();
            IClientDemo demo = new SequentialMessager();
            //IClientDemo demo = new SimpleLoop();
            demo.Start();
        }
    }
}
